#include "Consecutive_application.h"

#include "Timer.h"
#include "Log.h"

#include <iostream>

namespace MM
{

Consecutive_application::
Consecutive_application (int, char * argv[])
:
    name_(argv[0])
{
}

int Consecutive_application::
run ()
{
    Timer timer;

    while (!task_.empty())
    {
        Command *current_task = task_.front();
        task_.pop();
        current_task->execute();
        delete current_task;
    }

    Text message ("Duration ");
    message += timer.elapsed ();
    message += " sec.";
    std::cout  << message.c_str();
    log() << message << "\n\n";
    
    return 0;
}

}//MM

