#include "Console_configuration.h"

#include "Prototype_repository.h"

#include "Console_user.h"
#include "Console_application.h"
#include "Console_interface.h"
//#include "Console_simulation_task.h"
#include "New_model_console.h"

namespace MM
{

Console_configuration::
Console_configuration (int argc, char * argv[])
:
    Configuration (argc, argv)
{
    Prototype_repository & repository = Prototype_repository::singleton();

    repository.adopt ((User*)           new Console_user());
    repository.refer ((Application*)    new Console_application(argc,argv));
    repository.adopt ((User_interface*) new Console_interface());
//    repository.adopt ((Simulation_task*)new Console_simulation_task());
    repository.adopt ((New_model_impl*) new New_model_console());
}

}//MM
