#include "Prototype_repository.h"

#include "Prototype_repository_impl.h"

#include <typeinfo>

namespace MM
{

Prototype_repository::
Prototype_repository()
:
impl_ (new Prototype_repository_impl())
{
}

void Prototype_repository::
adopt (Any::Adopt const& prototype)
{
    Any tmp = prototype;
    impl_().adopt (tmp, tmp.type());
}

void Prototype_repository::
refer (Any const& prototype)
{
    impl_().adopt (prototype, prototype.type());
}

Any & Prototype_repository::
find (std::type_info const& class_name)
{
    return impl_().find (class_name);
}

Any & Prototype_repository::
find (Text const& type)
{
    return impl_().find (type);
}

void Prototype_repository::
adopt (Text const& type, Any::Adopt const& prototype)
{
    impl_().adopt (type, prototype);
}

Prototype_repository & Prototype_repository::
singleton ()
{
    static Prototype_repository instance;
    return instance;
}

void Prototype_repository::
destroy()
{
    if (singleton ().impl_.is_valid())
        delete singleton ().impl_.orphan();
}

}//MM



