#include "Transform_matrix_3D.h"

#include "math.h"

void Transform_matrix_3D::load_identity()
{
    for( int i = 0;  i < 3;  i++ )
        for( int j = 0;  j < 4;  j++ )
            a_[ i ] [ j ] = 0.0;

    a_[ 0 ] [ 0 ] = 1.0;
    a_[ 1 ] [ 1 ] = 1.0;
    a_[ 2 ] [ 2 ] = 1.0;
}

Transform_matrix_3D::~Transform_matrix_3D()
{
    for( int i = 0;  i < 3;  i++ )
        for( int j = 0;  j < 4;  j++ )
            a_[ i ] [ j ] = 0.0;
}

Transform_matrix_3D::Transform_matrix_3D()
{
    load_identity();
}

void Transform_matrix_3D::apply(double & x, double & y, double & z)
{
    double x_tmp = x,  y_tmp = y,  z_tmp = z;

    x = a_[ 0 ] [ 0 ] * x_tmp + a_[ 0 ] [ 1 ] * y_tmp + a_[ 0 ] [ 2 ] * z_tmp +
       a_[ 0 ] [ 3 ];
    y = a_[ 1 ] [ 0 ] * x_tmp + a_[ 1 ] [ 1 ] * y_tmp + a_[ 1 ] [ 2 ] * z_tmp +
       a_[ 1 ] [ 3 ];
    z = a_[ 2 ] [ 0 ] * x_tmp + a_[ 2 ] [ 1 ] * y_tmp + a_[ 2 ] [ 2 ] * z_tmp +
       a_[ 2 ] [ 3 ];
}

void Transform_matrix_3D::move(double x, double y, double z)
{
    a_[ 0 ] [ 3 ] += x;
    a_[ 1 ] [ 3 ] += y;
    a_[ 2 ] [ 3 ] += z;
}

void Transform_matrix_3D::rotate_z(double angle, double x, double y)
{
    double cos_angle = cos( angle );
    double sin_angle = sin( angle );
    Transform_matrix_3D tmp;

    tmp.a_[ 0 ] [ 0 ] = cos_angle * a_[ 0 ] [ 0 ] - sin_angle * a_[ 1 ] [ 0 ];
    tmp.a_[ 0 ] [ 1 ] = cos_angle * a_[ 0 ] [ 1 ] - sin_angle * a_[ 1 ] [ 1 ];
    tmp.a_[ 0 ] [ 2 ] = cos_angle * a_[ 0 ] [ 2 ] - sin_angle * a_[ 1 ] [ 2 ];

    tmp.a_[ 1 ] [ 0 ] = sin_angle * a_[ 0 ] [ 0 ] + cos_angle * a_[ 1 ] [ 0 ];
    tmp.a_[ 1 ] [ 1 ] = sin_angle * a_[ 0 ] [ 1 ] + cos_angle * a_[ 1 ] [ 1 ];
    tmp.a_[ 1 ] [ 2 ] = sin_angle * a_[ 0 ] [ 2 ] + cos_angle * a_[ 1 ] [ 2 ];

    tmp.a_[ 0 ] [ 3 ] = cos_angle * a_[ 0 ] [ 3 ] - sin_angle * a_[ 1 ] [ 3 ] -
       cos_angle * x + sin_angle * y + x;
    tmp.a_[ 1 ] [ 3 ] = sin_angle * a_[ 0 ] [ 3 ] + cos_angle * a_[ 1 ] [ 3 ] -
       sin_angle * x - cos_angle * y + y;

    a_[ 0 ] [ 0 ] = tmp.a_[ 0 ] [ 0 ];
    a_[ 0 ] [ 1 ] = tmp.a_[ 0 ] [ 1 ];
    a_[ 0 ] [ 2 ] = tmp.a_[ 0 ] [ 2 ];

    a_[ 1 ] [ 0 ] = tmp.a_[ 1 ] [ 0 ];
    a_[ 1 ] [ 1 ] = tmp.a_[ 1 ] [ 1 ];
    a_[ 1 ] [ 2 ] = tmp.a_[ 1 ] [ 2 ];

    a_[ 0 ] [ 3 ] = tmp.a_[ 0 ] [ 3 ];
    a_[ 1 ] [ 3 ] = tmp.a_[ 1 ] [ 3 ];
}

void Transform_matrix_3D::rotate_y(double angle, double x, double z)
{
    double cos_angle = cos( angle );
    double sin_angle = sin( angle );
    Transform_matrix_3D tmp;

    tmp.a_[ 0 ] [ 0 ] = cos_angle * a_[ 0 ] [ 0 ] + sin_angle * a_[ 2 ] [ 0 ];
    tmp.a_[ 0 ] [ 1 ] = cos_angle * a_[ 0 ] [ 1 ] + sin_angle * a_[ 2 ] [ 1 ];
    tmp.a_[ 0 ] [ 2 ] = cos_angle * a_[ 0 ] [ 2 ] + sin_angle * a_[ 2 ] [ 2 ];

    tmp.a_[ 2 ] [ 0 ] = -sin_angle * a_[ 0 ] [ 0 ] + cos_angle * a_[ 2 ] [ 0 ];
    tmp.a_[ 2 ] [ 1 ] = -sin_angle * a_[ 0 ] [ 1 ] + cos_angle * a_[ 2 ] [ 1 ];
    tmp.a_[ 2 ] [ 2 ] = -sin_angle * a_[ 0 ] [ 2 ] + cos_angle * a_[ 2 ] [ 2 ];

    tmp.a_[ 0 ] [ 3 ] = cos_angle * a_[ 0 ] [ 3 ] + sin_angle * a_[ 2 ] [ 3 ] -
       cos_angle * x - sin_angle * z + x;
    tmp.a_[ 2 ] [ 3 ] = -sin_angle * a_[ 0 ] [ 3 ] + cos_angle *
       a_[ 2 ] [ 3 ] + sin_angle * x - cos_angle * z + z;

    a_[ 0 ] [ 0 ] = tmp.a_[ 0 ] [ 0 ];
    a_[ 0 ] [ 1 ] = tmp.a_[ 0 ] [ 1 ];
    a_[ 0 ] [ 2 ] = tmp.a_[ 0 ] [ 2 ];

    a_[ 2 ] [ 0 ] = tmp.a_[ 2 ] [ 0 ];
    a_[ 2 ] [ 1 ] = tmp.a_[ 2 ] [ 1 ];
    a_[ 2 ] [ 2 ] = tmp.a_[ 2 ] [ 2 ];

    a_[ 0 ] [ 3 ] = tmp.a_[ 0 ] [ 3 ];
    a_[ 2 ] [ 3 ] = tmp.a_[ 2 ] [ 3 ];
}

void Transform_matrix_3D::rotate_x(double angle, double y, double z)
{
    double cos_angle = cos( angle );
    double sin_angle = sin( angle );
    Transform_matrix_3D tmp;

    tmp.a_[ 1 ] [ 0 ] = cos_angle * a_[ 1 ] [ 0 ] - sin_angle * a_[ 2 ] [ 0 ];
    tmp.a_[ 1 ] [ 1 ] = cos_angle * a_[ 1 ] [ 1 ] - sin_angle * a_[ 2 ] [ 1 ];
    tmp.a_[ 1 ] [ 2 ] = cos_angle * a_[ 1 ] [ 2 ] - sin_angle * a_[ 2 ] [ 2 ];

    tmp.a_[ 2 ] [ 0 ] = sin_angle * a_[ 1 ] [ 0 ] + cos_angle * a_[ 2 ] [ 0 ];
    tmp.a_[ 2 ] [ 1 ] = sin_angle * a_[ 1 ] [ 1 ] + cos_angle * a_[ 2 ] [ 1 ];
    tmp.a_[ 2 ] [ 2 ] = sin_angle * a_[ 1 ] [ 2 ] + cos_angle * a_[ 2 ] [ 2 ];

    tmp.a_[ 1 ] [ 3 ] = cos_angle * a_[ 1 ] [ 3 ] - sin_angle * a_[ 2 ] [ 3 ] -
       cos_angle * y + sin_angle * z + y;
    tmp.a_[ 2 ] [ 3 ] = sin_angle * a_[ 1 ] [ 3 ] + cos_angle * a_[ 2 ] [ 3 ] -
       sin_angle * y - cos_angle * z + z;

    a_[ 1 ] [ 0 ] = tmp.a_[ 1 ] [ 0 ];
    a_[ 1 ] [ 1 ] = tmp.a_[ 1 ] [ 1 ];
    a_[ 1 ] [ 2 ] = tmp.a_[ 1 ] [ 2 ];

    a_[ 2 ] [ 0 ] = tmp.a_[ 2 ] [ 0 ];
    a_[ 2 ] [ 1 ] = tmp.a_[ 2 ] [ 1 ];
    a_[ 2 ] [ 2 ] = tmp.a_[ 2 ] [ 2 ];

    a_[ 1 ] [ 3 ] = tmp.a_[ 1 ] [ 3 ];
    a_[ 2 ] [ 3 ] = tmp.a_[ 2 ] [ 3 ];
}
