#include "Test.h"

#include "HSV.h"

namespace MM
{

class HSV_test : public Test
{
public:
    HSV_test (const Text& suite_name) : Test (suite_name) { }

    void run()
    {
        test_HSV_to_RGB();      count_tests();
        test_RGB_to_HSV();      count_tests();
        test_reversibility();   count_tests();
        test_shift();           count_tests();
    }

    void test_HSV_to_RGB ()
    {
        double R, G, B;

        HSV_to_RGB (0,0,0, R,G,B);
        DOUBLES_EQUAL (0, R, 0.000001);
        DOUBLES_EQUAL (0, G, 0.000001);
        DOUBLES_EQUAL (0, B, 0.000001);

        HSV_to_RGB (1,0,0, R,G,B);
        DOUBLES_EQUAL (0, R, 0.000001);
        DOUBLES_EQUAL (0, G, 0.000001);
        DOUBLES_EQUAL (0, B, 0.000001);

        HSV_to_RGB (0,1,0, R,G,B);
        DOUBLES_EQUAL (0, R, 0.000001);
        DOUBLES_EQUAL (0, G, 0.000001);
        DOUBLES_EQUAL (0, B, 0.000001);

        HSV_to_RGB (0,0,1, R,G,B);
        DOUBLES_EQUAL (1, R, 0.000001);
        DOUBLES_EQUAL (1, G, 0.000001);
        DOUBLES_EQUAL (1, B, 0.000001);

        HSV_to_RGB (1,0,1, R,G,B);
        DOUBLES_EQUAL (1, R, 0.000001);
        DOUBLES_EQUAL (1, G, 0.000001);
        DOUBLES_EQUAL (1, B, 0.000001);

        HSV_to_RGB (0,1,1, R,G,B);          // Red
        DOUBLES_EQUAL (1, R, 0.000001);
        DOUBLES_EQUAL (0, G, 0.000001);
        DOUBLES_EQUAL (0, B, 0.000001);

        HSV_to_RGB (60,1,1, R,G,B);          
        DOUBLES_EQUAL (1, R, 0.000001);
        DOUBLES_EQUAL (1, G, 0.000001);
        DOUBLES_EQUAL (0, B, 0.000001);

        HSV_to_RGB (120,1,1, R,G,B);        // Green
        DOUBLES_EQUAL (0, R, 0.000001);
        DOUBLES_EQUAL (1, G, 0.000001);
        DOUBLES_EQUAL (0, B, 0.000001);

        HSV_to_RGB (180,1,1, R,G,B);        
        DOUBLES_EQUAL (0, R, 0.000001);
        DOUBLES_EQUAL (1, G, 0.000001);
        DOUBLES_EQUAL (1, B, 0.000001);

        HSV_to_RGB (240,1,1, R,G,B);        // Blue
        DOUBLES_EQUAL (0, R, 0.000001);
        DOUBLES_EQUAL (0, G, 0.000001);
        DOUBLES_EQUAL (1, B, 0.000001);

        HSV_to_RGB (300,1,1, R,G,B);        
        DOUBLES_EQUAL (1, R, 0.000001);
        DOUBLES_EQUAL (0, G, 0.000001);
        DOUBLES_EQUAL (1, B, 0.000001);

        HSV_to_RGB (0,.5,1, R,G,B);          // Half saturated Red
        DOUBLES_EQUAL (1., R, 0.000001);
        DOUBLES_EQUAL (.5, G, 0.000001);
        DOUBLES_EQUAL (.5, B, 0.000001);

        HSV_to_RGB (120,.5,1, R,G,B);        // Half saturated Green
        DOUBLES_EQUAL (.5, R, 0.000001);
        DOUBLES_EQUAL (1., G, 0.000001);
        DOUBLES_EQUAL (.5, B, 0.000001);

        HSV_to_RGB (240,.5,1, R,G,B);        // Half saturated Blue
        DOUBLES_EQUAL (.5, R, 0.000001);
        DOUBLES_EQUAL (.5, G, 0.000001);
        DOUBLES_EQUAL (1., B, 0.000001);

        HSV_to_RGB (0,1,.5, R,G,B);          // Half Red
        DOUBLES_EQUAL (.5, R, 0.000001);
        DOUBLES_EQUAL (.0, G, 0.000001);
        DOUBLES_EQUAL (.0, B, 0.000001);

        HSV_to_RGB (120,1,.5, R,G,B);        // Half Green
        DOUBLES_EQUAL (.0, R, 0.000001);
        DOUBLES_EQUAL (.5, G, 0.000001);
        DOUBLES_EQUAL (.0, B, 0.000001);

        HSV_to_RGB (240,1,.5, R,G,B);        // Half Blue
        DOUBLES_EQUAL (.0, R, 0.000001);
        DOUBLES_EQUAL (.0, G, 0.000001);
        DOUBLES_EQUAL (.5, B, 0.000001);
    }

    void test_RGB_to_HSV ()
    {
        double H, S, V;

        RGB_to_HSV (0,0,0, H,S,V);
        DOUBLES_EQUAL (.0, H, 0.000001);
        DOUBLES_EQUAL (.0, S, 0.000001);
        DOUBLES_EQUAL (.0, V, 0.000001);

        RGB_to_HSV (1,0,0, H,S,V);
        DOUBLES_EQUAL (0,   H, 0.000001);
        DOUBLES_EQUAL (1.,  S, 0.000001);
        DOUBLES_EQUAL (1.,  V, 0.000001);

        RGB_to_HSV (0,1,0, H,S,V);
        DOUBLES_EQUAL (120, H, 0.000001);
        DOUBLES_EQUAL (1.,  S, 0.000001);
        DOUBLES_EQUAL (1.,  V, 0.000001);

        RGB_to_HSV (0,0,1, H,S,V);
        DOUBLES_EQUAL (240, H, 0.000001);
        DOUBLES_EQUAL (1.,  S, 0.000001);
        DOUBLES_EQUAL (1.,  V, 0.000001);

        RGB_to_HSV (1,1,0, H,S,V);
        DOUBLES_EQUAL (60,  H, 0.000001);
        DOUBLES_EQUAL (1.,  S, 0.000001);
        DOUBLES_EQUAL (1.,  V, 0.000001);

        RGB_to_HSV (0,1,1, H,S,V);
        DOUBLES_EQUAL (180, H, 0.000001);
        DOUBLES_EQUAL (1.,  S, 0.000001);
        DOUBLES_EQUAL (1.,  V, 0.000001);

        RGB_to_HSV (1,0,1, H,S,V);
        DOUBLES_EQUAL (300, H, 0.000001);
        DOUBLES_EQUAL (1.,  S, 0.000001);
        DOUBLES_EQUAL (1.,  V, 0.000001);

        RGB_to_HSV (1,1,1, H,S,V);
        DOUBLES_EQUAL (.0, H, 0.000001);
        DOUBLES_EQUAL (.0, S, 0.000001);
        DOUBLES_EQUAL (1., V, 0.000001);
    }

    void test_reversibility ()
    {
        double R, G, B;
        double H, S, V;

        R = 0.123;
        G = 0.456;
        B = 0.789;
        RGB_to_HSV (R,G,B, H,S,V);
        R = 0.;
        G = 0.;
        B = 0.;
        HSV_to_RGB (H,S,V, R,G,B);
        DOUBLES_EQUAL (0.123, R, 0.000001);
        DOUBLES_EQUAL (0.456, G, 0.000001);
        DOUBLES_EQUAL (0.789, B, 0.000001);

        R = 0.987;
        G = 0.654;
        B = 0.321;
        RGB_to_HSV (R,G,B, H,S,V);
        R = 0.;
        G = 0.;
        B = 0.;
        HSV_to_RGB (H,S,V, R,G,B);
        DOUBLES_EQUAL (0.987, R, 0.000001);
        DOUBLES_EQUAL (0.654, G, 0.000001);
        DOUBLES_EQUAL (0.321, B, 0.000001);
    }

    void test_shift()
    {
        double R1, G1, B1;
        double R2, G2, B2;
        double R3, G3, B3;
        double H = 72, S = 0.56, V = 0.32;

        HSV_to_RGB (H,    S,V, R1,G1,B1);
        HSV_to_RGB (H+360,S,V, R2,G2,B2);
        HSV_to_RGB (H-360,S,V, R3,G3,B3);

        DOUBLES_EQUAL (R1, R2, 0.000001);
        DOUBLES_EQUAL (G1, G2, 0.000001);
        DOUBLES_EQUAL (B1, B2, 0.000001);

        DOUBLES_EQUAL (R1, R3, 0.000001);
        DOUBLES_EQUAL (G1, G3, 0.000001);
        DOUBLES_EQUAL (B1, B3, 0.000001);
    }
};

HSV_test test_hsv ("correctness");

}//MM

