// 
// This file is part of MolMeccano, a cross-platform C++ chemical library.
//
// Copyright (C) 2001-2007 Alexey Nikitin
//

//namespace MolMeccano { }
//namespace MM = MolMeccano;

#include "Console_user.h"

#include "Text.h"
#include "Flaw.h"

#include <iostream>

namespace MM
{

void Console_user::
fatal_error (Text const & message)
{
    std::cout << "Fatal error:  " << message.c_str() << std::endl;
    throw;
}

void Console_user::
error (Text const & message)
{
    std::cout << "Error:  " << message.c_str() << std::endl;
}

void Console_user::
warning (Text const & message)
{
    std::cout << "Warning:  " << message.c_str() << std::endl;
}

void Console_user::
info (Text const & message)
{
    std::cout << "Info:  " << message.c_str() << std::endl;
}

void Console_user::
status (Text const & message)
{
    std::cout << "Status:  " << message.c_str() << std::endl;
}

bool Console_user::
//question (Text const & message)
question (Text const &)
{
    FIX;
}

bool Console_user::
choose (Text const & , Array <Text> const & , Text & )
{
    FIX;
}

bool Console_user::
choose (Text const & , Array <Text> const & , int & )
{
    FIX;
}

void Console_user::
//inquiry (Text const & message, Text & response)
inquiry (Text const &, Text &)
{
    FIX;
}

}//MM


