// 
// This file is part of MolMeccano, a cross-platform C++ chemical library.
//
// Copyright (C) 2001-2007 Alexey Nikitin
//

#ifndef CONSOLE_USER_H
#define CONSOLE_USER_H

#ifndef USER_H
#include "User.h"
#endif

namespace MM
{

class Console_user : public User
{
public:
    virtual void    status      (Text const & message);
    virtual void    clock       () {}

    virtual void    info        (Text const & message);
    virtual void    warning     (Text const & message);
    virtual void    error       (Text const & message);
    virtual void    fatal_error (Text const & message);
    virtual bool    question    (Text const & message);

    virtual bool    choose      (Text const& question, 
                                 Array <Text> const& list,
                                 Text & result);

    virtual bool    choose      (Text const& question, 
                                 Array <Text> const& list, 
                                 int & n);

    virtual void    inquiry     (Text const & message, Text & response);
};

}//MM

#endif //CONSOLE_USER_H


