// 
// This file is part of MolMeccano, a cross-platform C++ chemical library.
//
// Copyright (C) 2001-2007 Alexey Nikitin
//
#include "File_input.h"

//#include <string.h>
//#include <ctype.h>

namespace MM
{

File_input::File_input(Text filename)
: file_ptr_( filename.c_str(), "r" )
{
}

bool  File_input::
next_double( double * value )
{ 
    int result = fscanf( file_ptr_, "%lg", value );
    if( result <= 0 && feof(file_ptr_) == 0 ) 
        FLAW("Can not read double.");
    return result != 0;
}

bool   File_input::
next_float( float * value )
{
    int result = fscanf( file_ptr_, "%g", value );
    if( result <= 0 && feof(file_ptr_) == 0 ) 
        FLAW("Can not read float.");
    return result != 0;
}

bool    File_input::
next_int( int * value )
{
    int result = fscanf( file_ptr_, "%i", value );
    if( result <= 0 && feof(file_ptr_) == 0 ) 
        FLAW("Can not read integer.");
    return result != 0;
}

bool    File_input::
//next_word( char* str, int size )
next_word( char* str, int ) //fix size
{
    int result = fscanf( file_ptr_, "%s", str );
    if( result <= 0 && feof(file_ptr_) == 0 ) 
        FLAW("Can not read word.");
    return result != 0;
}

bool    File_input::
next_line (char* str, int size)
{   
    REQUIRE ("", size > 0);

    int c, max_size = size - 2;
    for (int counter=0;  counter<max_size;  counter++) 
    {  
        c = fgetc (file_ptr_);
        if (c == EOF)
        {
            str[counter] = 0;

            if (ferror (file_ptr_) != 0)
                FLAW ("Can not read line.");

            if (counter == 0)
                return false;
            else
                return true;
        }

        if (c=='\n')
        { 
            str[counter] = c;
            counter++;
            
            c = fgetc (file_ptr_);

            if (c=='\r') 
            {
                str[counter] = c;
                counter++;
                str[counter] = 0;
                return true;
            }
               
            str[counter] = 0;
            ungetc (c, file_ptr_);
            return true; 
        }

        if (c=='\r')
        { 
            str[counter] = c;
            counter++;
            
            c = fgetc (file_ptr_);

            if (c=='\n') 
            {
                str[counter] = c;
                counter++;
                str[counter] = 0;
                return true;
            }
               
            str[counter] = 0;
            ungetc (c, file_ptr_);
            return true; 
        }

        str[counter] = c;
    }

    str[max_size] = 0; 
    return true;

    //*/

    /*int c;
    for (int counter=0; ;  counter++) 
    {  
        c = fgetc(file_ptr_);
        if(c==EOF && ferror(file_ptr_) != 0 )
            FLAW ("Can not read line.");

        if (c=='\n' || c=='\r' || c==EOF) 
        { 
            str[counter] = 0;
            
            if (c==EOF)
            {
                if (counter == 0)
                    return false;
                else
                    return true;
            }

            for (;;)
            {
                c = fgetc (file_ptr_);

                if (c=='\r' || c=='\n') continue; 
                if (c==EOF)             return true;
                ungetc (c, file_ptr_);
                break; 
            }
            return true; 
        }
        str[counter] = c;
    }//*/
    /*char * result = fgets( str, size, file_ptr_ );
    if( result == NULL && ferror(file_ptr_) != 0 )
        FLAW("Can not read line.");

    return result != NULL;//*/

    FLAW ("Should not be here");
}

}//MM
