// 
// This file is part of MolMeccano, a cross-platform C++ chemical library.
//
// Copyright (C) 2001-2007 Alexey Nikitin
//
#ifndef FILE_INPUT_H
#define FILE_INPUT_H

#ifndef INPUT_H
#include "Input.h"
#endif

#ifndef FILE_PTR_H
#include "File_ptr.h"
#endif

#ifndef DBC_H
#include "DbC.h"
#endif

namespace MM
{

class File_input : public Input, protected DbC
{
    File_ptr        file_ptr_;

public:
    File_input (Text filename);

    virtual bool  next_line( char*, int size );

    virtual bool  next_word( char* str, int size );
    virtual bool  next_int( int * value );
    virtual bool  next_float( float * value );
    virtual bool  next_double( double * value );
};

}//MM

#endif //FILE_INPUT_H

