// 
// This file is part of MolMeccano, a cross-platform C++ chemical library.
//
// Copyright (C) 2001-2007 Alexey Nikitin
//

#ifndef FILE_PTR_H
#define FILE_PTR_H

#ifdef WIN32
#pragma warning (disable : 4996)
#endif

#ifndef FLAW_H
#include "Flaw.h"
#endif

#include <stdio.h>

namespace MM
{

class   File_ptr
{
    FILE        *ptr_;

public:
    //File_ptr () : ptr_(0) {}//fix
    File_ptr( const char* filename, const char* mode  )
    { 
        ptr_ = fopen( filename, mode  );
        if( ptr_ == 0 )  
            FLAW( Text("Can not open file ") + filename + "." );
    }

    ~File_ptr()             {fclose (ptr_);  ptr_=0;}

    FILE* operator -> ()    {return ptr_;}
    operator FILE* ()       {return ptr_;}
};

}//MM

#endif//FILE_PTR_H
