// 
// This file is part of MolMeccano, a cross-platform C++ chemical library.
//
// Copyright (C) 2001-2007 Alexey Nikitin
//
#include "File_text_input.h"


namespace MM
{

File_text_input::File_text_input (Text filename)
: file_ptr_(filename.c_str(), "r")
{
}

bool File_text_input::
next_double (double * value)
{ 
    int result = fscanf (file_ptr_, "%lg", value);
    if (result <= 0 && feof (file_ptr_) == 0) 
        FLAW("Can not read double.");
    return result != 0;
}

bool File_text_input::
next_float (float * value)
{
    int result = fscanf (file_ptr_, "%g", value);
    if (result <= 0 && feof(file_ptr_) == 0) 
        FLAW("Can not read float.");
    return result != 0;
}

bool File_text_input::
next_int (int * value)
{
    int result = fscanf (file_ptr_, "%i", value);
    if (result <= 0 && feof(file_ptr_) == 0)
        FLAW("Can not read integer.");
    return result != 0;
}

bool File_text_input::
next_char (char* value)
{
    int result = fscanf (file_ptr_, "%c", value);
    if (result <= 0 && feof (file_ptr_) == 0)
        FLAW("Can not read char.");
    return !feof (file_ptr_) && result == 1; //fix all
}

bool File_text_input::
//next_word (char* str, int size)
next_word (char* str, int ) //fix size
{
    int result = fscanf (file_ptr_, "%s", str);
    if (result <= 0 && feof (file_ptr_) == 0) 
        FLAW("Can not read word.");
    return result != 0;
}

bool File_text_input::
next_line (char * str, int size)
{
    char * result = fgets (str, size, file_ptr_);
    if (result == NULL && ferror(file_ptr_) != 0)
        FLAW("Can not read line.");
    return result != NULL;
}

}//MM
