// 
// This file is part of MolMeccano, a cross-platform C++ chemical library.
//
// Copyright (C) 2001-2007 Alexey Nikitin
//
#ifndef FILE_TEXT_INPUT_H
#define FILE_TEXT_INPUT_H

#ifndef TEXT_INPUT_H
#include "Text_input.h"
#endif

#ifndef FILE_PTR_H
#include "File_ptr.h"
#endif

namespace MM
{

class File_text_input : public Text_input
{
    File_ptr        file_ptr_;

public:
    File_text_input (Text filename);

    virtual bool  next_line   (char * , int size);

    virtual bool  next_word   (char* str, int size);
    virtual bool  next_char   (char* value);
    virtual bool  next_int    (int * value);
    virtual bool  next_float  (float * value);
    virtual bool  next_double (double * value);
};

}//MM

#endif //FILE_TEXT_INPUT_H

