// 
// This file is part of MolMeccano, a cross-platform C++ chemical library.
//
// Copyright (C) 2001-2007 Alexey Nikitin
//

//namespace MolMeccano { }
//namespace MM = MolMeccano;

#include "File_text_output.h"

#include "Text.h"

namespace MM
{

/*File_text_output::
File_text_output()
{
}//*/


File_text_output::
File_text_output( const Text & filename, const Text & mode )
: file_ptr_( filename.c_str(), mode.c_str() )
{
}

Text_output & File_text_output::
line( const Text & text )
{
    fprintf( file_ptr_, "%s\n", text.c_str() );
    return * this;
}

Text_output & File_text_output::
text( const Text & text )
{
    fprintf( file_ptr_, "%s", text.c_str() );
    return * this;
}

Text_output & File_text_output::
flush() 
{
    fflush( file_ptr_ );
    return * this;
}

}//MM

