#include "Test.h"

#include "File_input.h"
#include "Path.h"
#include "Log.h"
#include <math.h> 

namespace MM
{

class Input_test : public Test
{
    File_input* link;
public:
    Input_test (const Text & suite_name) : Test (suite_name) { }

    void run()
    {
        test_read_file();    count_tests();
    }
    void test_read_file();
};

Input_test test_input ("correctness");

void Input_test::
test_read_file ()
{
    File_input in (Path::tests() + "sample_file.txt");

    char str[101];
    bool result;

    result = in.next_word(str,100);
    TEST ("", Text(str) == "First" && result);

    result = in.next_word(str,100);
    TEST ("", Text(str) == "test"  && result);

    result = in.next_word(str,100);
    TEST ("", Text(str) == "string:" && result);

    result = in.next_word(str,100);
    TEST ("", Text(str) == "qwertyuiop[" && result);

    result = in.next_line(str,100);
    TEST ("", (Text(str) == " asdfghjkl;' zxcvbnm,\n"
        ||    Text(str) == " asdfghjkl;' zxcvbnm,\r\n")  && result);

    int ivalue;
    result = in.next_int(&ivalue);
    TEST ("",ivalue == 123 && result);

    float fvalue;
    result = in.next_float(&fvalue);
    TEST ("delivered float must be near 345.66",
        fabs (fvalue - 345.66 ) < 0.001 && result);

    double dvalue;
    result = in.next_double(&dvalue);
    TEST ("delivered double must be near 1234567890.12345678", 
        dvalue - 1234567890.12345678 < 0.001  && result);

    TEST ("",in.next_line(str,100) == true);
    TEST ("",in.next_line(str,100) == true);
    TEST ("",in.next_line(str,100) == false);

//    First test string: qwertyuiop[  asdfghjkl;' zxcvbnm,
//    123 345.66 1234567890.12345678
//    ********************************************************************************************

}

}//MM
