// 
// This file is part of MolMeccano, a cross-platform C++ chemical library.
//
// Copyright (C) 2001-2007 Alexey Nikitin
//
#include "Log.h"

#include "Path.h"
#include "Text.h"
#include "File_text_output.h"
#include "Text_output.h"
#include "Information.h"

namespace MM
{

Logger::
Logger()
: 
    on_(true)
{
    out_= Own<Text_output>(new File_text_output (Path::report() +"_log.txt"));
    ENSURE ("Output exist", out_.was_initialized());
}

Logger & Logger::
singleton()
{
    static Logger instance;
    return instance;
}

Own <Text_output> Logger::
set_output (Text_output * output)
{
    REQUIRE ("Output exist", output != 0);

    Text_output * old = out_.orphan();
    out_.adopt (output);
    return Own<Text_output> (old);
}

Logger & Logger::
operator << (const Text & text) 
{
    REQUIRE ("Output exist", out_.was_initialized());

    if (is_on())
    {
        out_().text (text);
        out_().flush();

        Information::singleton().add_log (text);
    }
    return *this;
}

Text_output & Logger::
text (const Text & t)
{
    out_().text (t);
    return *this;
}

Text_output & Logger::
line (const Text & t)
{
    out_().line (t);
    return *this;
}

Text_output & Logger::
flush ()
{
    out_().flush();
    return *this;
}

}//MM
