// 
// This file is part of MolMeccano, a cross-platform C++ chemical library.
//
// Copyright (C) 2001-2007 Alexey Nikitin
//
#ifndef LOG_H
#define LOG_H

#ifndef TEXT_OUTPUT_H
#include "Text_output.h"
#endif

#ifndef DBC_H
#include "DbC.h"
#endif

#ifndef OWN_H
#include "Own.h"
#endif

namespace MM
{

class Text;

class Logger : public Text_output, private DbC
{
    Own <Text_output>           out_;      //fix to * (Polymorphic)
    bool                        on_;
    Logger();

public:
    static Logger &             singleton();
    Own <Text_output>           set_output (Text_output * output);
    Logger &                    operator << (const Text & text);

    bool                        is_on  () const         {return on_; }
    void                        set_on (bool value)     {on_ = value;}

    // Text_output
    virtual Text_output &       text (const Text &);
    virtual Text_output &       line (const Text &);
    virtual Text_output &       flush();
};

inline Logger & log ()
{
    return Logger::singleton();
}

}//MM

#endif//LOG_H
