#include "Test.h"

#include "File_text_output.h"
#include "Own.h"
#include "Path.h"
#include "Log.h"

namespace MM
{

class Logger_test : public Test
{
public:
    Logger_test( const Text & suite_name ) : Test( suite_name ) { }

    class Output : public Text_output
    {
        Own <Text_output>       out_;

    public:
        Text                    last_record_;
        Output();

        virtual Text_output &   text (const Text &);
        virtual Text_output &   line (const Text &);
    };

    Output *test_output_;

    void run()
    {
        Own<Text_output>  old_logger_output;
        test_output_ = new Output;
        old_logger_output = log().set_output (test_output_);

        test1_text();       count_tests();
        test2_numbers();    count_tests();
        test3_strings();    count_tests();

        log().set_output (old_logger_output.orphan());
    }

    void test1_text();
    void test2_numbers();
    void test3_strings();
};

Logger_test test_logger ("correctness");

Logger_test::Output::
Output()
{
    out_.adopt (new File_text_output (Path::tests_rubbish() + "_log_test.txt" ));
}

Text_output & Logger_test::Output::
text (const Text & text)
{
    out_().text (text);
    last_record_ = text;
    return *this;
}

Text_output & Logger_test::Output::
line (const Text & text)
{
    out_().line (text);
    last_record_ = text;
    return *this;
}


void Logger_test::
test1_text ()
{
    log() << Text();
    TEST ("Test class Text", test_output_->last_record_ == "");
    log() << "\n";

    log() << Text ("Test 1 text");
    TEST ("Test class Text", test_output_->last_record_ == "Test 1 text");
    log() << "\n";
}

void Logger_test::
test2_numbers ()
{
    bool            _bool           = false;
    char            _char           = 'a';
    short           _short          = 1;
    int             _int            = 2;
    long            _long           = 3;
    unsigned short  _unsigned_short = 4;
    unsigned int    _unsigned_int   = 5;
    unsigned long   _unsigned_long  = 6;
    float           _float          = float(7.7);
    double          _double         = 8.8;
    long double     _long_double    = 9.9;
    void           *_void           = (void*)0x11110000;

    log() << _bool;          TEST("Test bool",          test_output_->last_record_ == "false"); log() << "\n";
    log() << true;           TEST("Test bool",          test_output_->last_record_ == "true" ); log() << "\n";
    log() << _char;          TEST("Test char",          test_output_->last_record_ == "a"    ); log() << "\n";
    log() << _short;         TEST("Test short",         test_output_->last_record_ == "1"    ); log() << "\n";
    log() << _int;           TEST("Test int",           test_output_->last_record_ == "2"    ); log() << "\n";
    log() << _long;          TEST("Test long",          test_output_->last_record_ == "3"    ); log() << "\n";
    log() << _unsigned_short;TEST("Test unsigned short",test_output_->last_record_ == "4"    ); log() << "\n";
    log() << _unsigned_int;  TEST("Test unsigned int",  test_output_->last_record_ == "5"    ); log() << "\n";
    log() << _unsigned_long; TEST("Test unsigned long", test_output_->last_record_ == "6"    ); log() << "\n";
    log() << _float;         TEST("Test float",         test_output_->last_record_ == "7.7"  ); log() << "\n";
    log() << _double;        TEST("Test double",        test_output_->last_record_ == "8.8"  ); log() << "\n";
    log() << _long_double;   TEST("Test long double",   test_output_->last_record_ == "9.9"  ); log() << "\n";
    log() << _void;          TEST("Test void*",    test_output_->last_record_ == "11110000" ||
                                                       test_output_->last_record_ == "0x11110000");log() << "\n";
}

void Logger_test::
test3_strings ()
{
/*    const std::string  text1 = "std::string";
    log() << text1.c_str();
    TEST( "Test std::string", test_output_->last_record_ == "std::string" );
    log() << "\n";//*/

    const char        text2[] = "char*";
    log() << text2;
    TEST ("Test char*", test_output_->last_record_ == "char*");
    log() << "\n";
}

}//MM
