#ifndef SLEEP_H
#define SLEEP_H

#ifdef MM_WIN32

#ifndef INCLUDED_WINBASE_H
#include "windows.h"
#define INCLUDED_WINBASE_H
#endif

namespace MM
{
inline void 
sleep (int msec)	{Sleep (msec);}
}

#elif MM_UNIX

#ifndef INCLUDED_UNISTD_H
#include <unistd.h>
#define INCLUDED_UNISTD_H
#endif

namespace MM
{
inline void 
sleep (int msec)	{usleep (1000*msec);}
}

#else
    #error "Unknown platform"
#endif

#endif //SLEEP_H
