// 
// This file is part of MolMeccano, a cross-platform C++ chemical library.
//
// Copyright (C) 2001-2007 Alexey Nikitin
//
#include "Std_text_output.h"

#include "Text.h"

#include <stdio.h>

namespace MM
{

Std_text_output::Std_text_output()
{
}

Text_output & Std_text_output::
line( const Text & text )
{
    printf( "%s\n", text.c_str() );
    return * this;
}

Text_output & Std_text_output::
text( const Text & text )
{
    printf( "%s", text.c_str() );
    return * this;
}

Text_output & Std_text_output::
flush() 
{
    fflush( stdout );
    return * this;
}

}//MM

