// 
// This file is part of MolMeccano, a cross-platform C++ chemical library.
//
// Copyright (C) 2001-2007 Alexey Nikitin
//
#ifndef TEXT_INPUT_H
#define TEXT_INPUT_H

#ifndef TEXT_H
#include "Text.h"
#endif

namespace MM
{

class Text_input
{
public:    
    virtual ~Text_input();
    virtual bool  next_line   (char*, int size) =0;

    virtual bool  next_word   (char* str, int size) =0;
    virtual bool  next_char   (char* value) =0;
    virtual bool  next_int    (int * value) =0;
    virtual bool  next_float  (float * value) =0;
    virtual bool  next_double (double * value) =0;
};

}//MM

#endif //TEXT_INPUT_H
