// 
// This file is part of MolMeccano, a cross-platform C++ chemical library.
//
// Copyright (C) 2001-2007 Alexey Nikitin
//
#ifndef USER_H
#define USER_H

#ifndef ARRAY_H
#include "Array.h"
#endif

namespace MM
{

class User;
class Text;
//template class Array_of <class T>;

//fix
/*
class Any
{
    User *user_;
public:
    User & user() { return *user_; }
    void   set_user( User & );
}
//*/
User & to_user();

class User
{
public:
    virtual        ~User() { }

    virtual void    status      (Text const& message) =0;

    virtual void    info        (Text const& message) =0;
    virtual void    warning     (Text const& message) =0;
    virtual void    error       (Text const& message) =0;
    virtual void    fatal_error (Text const& message) =0;

    virtual void    clock       () =0;

    virtual bool    question    (Text const& message) =0;

    virtual bool    choose      (Text const& question, 
                                 Array <Text> const& list,
                                 Text & result) =0;

    virtual bool    choose      (Text const& question, 
                                 Array <Text> const& list, 
                                 int & n) =0;
};

}//MM

#endif //USER_H


