#include "Test.h"

#include "Log.h"
#include "User.h"

#include "Mach_eps.h"
#include "Timer.h"
#include "Lock.h"
#include "Atom_impl.h"
#include "Model.h"
#include "Path.h"
#include "Create.h"
#include "Force_field.h"

#include "Conventional_interactions.h"

#include "Arbitrary_atom_group.h"
#include "Arbitrary_bond_group.h"
#include "Default_bond.h"

namespace MM
{

class AMBER_interactions_test : public Test
{
    Conventional_interactions *link;

    Force_field     *force_field_;

public:
    AMBER_interactions_test (const Text & suite_name) 
        : Test (suite_name) 
    {
    }

    void run()
    {
        force_field_ = new Force_field ("AMBER94");

/*        test_H          ();         count_tests();
        test_He         ();         count_tests();
        test_HH         ();         count_tests();
        test_q1_1A      ();         count_tests();

        test_CH         ();         count_tests();

        test_C2         ();         count_tests();
        test_C2H        ();         count_tests();
        test_C2H2       ();         count_tests();
        test_C2H6       ();         count_tests();

        test_CONH       ();         count_tests();
//        test_C3H4_hin   ();       count_tests();
//        test_C3H4_xyz   ();       count_tests();
        test_C20        ();         count_tests();

        test_C2H6_optimization ();  count_tests();

        test_B_DNA_6    ();         count_tests();
        test_B_DNA_12   ();         count_tests();

        //test_1crn       ();       count_tests();
        //test_20alpha_zh ();       count_tests();//*/

        delete force_field_;
    }

};

AMBER_interactions_test test_AMBER_interactions ("correctness");

}//MM
