#include "Bond_group_cache.h"

#include "Create.h"
#include "Atom_group_cache.h"
#include "Bond_group.h"

namespace MM
{

Bond_group_cache::
Bond_group_cache (Bond_group & bond_group, Atom_group & atom_group)
:
    Atom_group_cache (atom_group),
    bond_group_ (bond_group) 
{
}

/*void Bond_group_cache::
set_lock (bool on)
{
    Atom_group_cache::set_lock (on);

    if (on)
    {
        cache_bonds ();
//        cache_flag_ = true;
    }
    else
    {
//        flush_force ();
        bond_.clear ();
//       cache_flag_ = false;
    }
}//*/

void Bond_group_cache::
cache_bonds ()
{
    //cache_atoms ();

    if (&bond_group_ == &nil<Bond_group>())
        return;

    int count = bond_group_.bond_count();

    for (int i=0;  i<count;  ++i) //fix many center bonds
    {
        Bond_cache bond;
        
        bond.first_atom___  = bond_group_.bond (i).atom (0).kit().cache___;
        bond.second_atom___ = bond_group_.bond (i).atom (1).kit().cache___;
        bond.flag___        = 0;
        bond.origin___      = &bond_group_.bond (i);
        bond.number___      = i;

        bond_.push_back (bond);
        bond_group_.bond(i).kit().cache___ = &bond_.back ();
    }
}

}//MM
