#include "Common_interactions.h"

#include "Model_kit.h"

namespace MM
{
bool Common_interactions::ad_hoc_ = false;

void  Common_interactions::
report (Text *result, Text const & )
{
    *result += title();
    *result += "\n";

    *result += "\nwater           \t";
    *result += Text (water_potential_, 15);
    *result += "\nbond            \t";
    *result += Text (bond_potential_, 15);
    *result += "\nangle           \t";
    *result += Text (angle_potential_, 15);
    *result += "\ntorsion         \t";
    *result += Text (torsion_potential_, 15);
    *result += "\nimproper        \t";
    *result += Text (improper_torsion_potential_, 15);
    //*result += "\nhydrophobic     \t";
    //*result += Text (hydrophobic_potential_, 15);
    *result += "\nVan der Waals   \t";
    *result += Text (Van_der_Waals_potential_, 15);
    *result += "\nelectrostatic   \t";
    *result += Text (electrostatic_potential_, 15);
    *result += "\nsolvation        \t";
    *result += Text (last_continuum_solvation_potential(), 15);
    *result += "\ninduction        \t";
    *result += Text (last_induction_potential(), 15);
    *result += "\n";

    *result += "\n E = ";
    *result += last_potential_;
    *result += "\n";
}

Force_field &       Common_interactions::force_field ()       {return model_.kit().force_field();}
Force_field const & Common_interactions::force_field () const {return model_.kit().force_field();}

}//MM
