#ifndef COMMONPLACE_INTERACTIONS_H
#define COMMONPLACE_INTERACTIONS_H

#ifndef COMMON_INTERACTIONS_H
#include "Common_interactions.h"
#endif

namespace MM
{
class Atom;
class Bond;
class Atom_group;
class Bond_group;

class Commonplace_interactions : public Common_interactions
{
    Atom_group &        atom_group_;
    Bond_group &        bond_group_;

public:
    Interaction * clone () const
    {return new Commonplace_interactions (model_);}
         //(atom_group_, bond_group_, force_field_);}

    //Common_interactions *   clone (Atom_group &  atom_group,
    //                               Bond_group &  bond_group,
    //                               Force_field & ff) const
    //{return new Commonplace_interactions (atom_group, bond_group, ff);}

    Common_interactions *   clone (Model &       model/*,
                                   Force_field & ff*/) const
    {return new Commonplace_interactions (model/*, ff*/);}

    //Commonplace_interactions (Atom_group  & atom_group,
    //                          Bond_group  & bond_group,
    //                          Force_field & ff);

    //Commonplace_interactions (Atom_group  & atom_group,
    //                          Force_field & ff);

    Commonplace_interactions (Model &       model/*,
                              Force_field & ff*/);

    virtual double      potential   ();
    virtual void        zero_forces ();
    virtual void        add_force   ();

    virtual Text        title () const {return "Commonplace";}

protected:
    virtual int         atom_count();
    virtual int         bond_count();

    virtual void        atom_potential          (Atom & atom);
    virtual void        bond_potential          (Bond const & bond);

    virtual void        nonbonded_potential     (Atom       & atom);
    virtual void        angle_potential         (Atom const & /*atom*/){}
    virtual void        bond_stretch_potential  (Bond const & /*bond*/){}
    virtual void        torsion_potential       (Bond const & /*bond*/){}

    virtual void        add_atom_force          (Atom &       atom);
    virtual void        add_bond_force          (Bond &       bond);

    virtual void        add_nonbonded_force     (Atom &       /*atom*/){}
    virtual void        add_angle_force         (Atom &       /*atom*/){}
    virtual void        add_bond_stretch_force  (Bond &       /*bond*/){}
    virtual void        add_torsion_force       (Bond &       /*bond*/){}

    virtual void        process_14              (Atom &, bool /*force*/){}

    virtual void        miss_neighbours         (Atom const &){}
    virtual void        restore_neighbours      (){}
};

}//MM

#endif //COMMONPLACE_INTERACTIONS_H
