#include "Coulomb_interactions.h"

#include "Defs.h"
#include "Length.h"
#include "Atom.h"
#include "Point_3D.h"
#include "Atom_group.h"

namespace MM
{
double Coulomb_interactions::
potential ()
{               //fix 1-4, ...
    double last_potential_ = 0;

    for (int i=0;  i<atoms_.atom_count();  ++i)
    {
        Atom &atom1 = atoms_.atom (i);
        double q1 = EPS0 * atom1.charge();

        for (int j=i+1;  j<atoms_.atom_count();  ++j)
        {
            Atom &atom2 = atoms_.atom (j);
            double q2 = atom2.charge();
            //double e = q1 * q2 / Length (atom1, atom2).value();
            double e = q1 * q2 / atom1.position(). distance (atom2.position());
            last_potential_ += e;
        }
    }
    return last_potential_;
}
}//MM
