#ifndef DISTANCE_RESTRAINT_H
#define DISTANCE_RESTRAINT_H

#ifndef INTERACTION_FRAME_H
#include "Interaction_frame.h"
#endif

#ifndef ATOM_H
#include "Atom.h"
#endif

namespace MM
{
class Prototype;
//class Text;

class Distance_restraint : public Interaction_frame//, public Bond_length
{
    Atom &                  atom1_;
    Atom &                  atom2_;

    double                  R_eqv_;
    double                  K_r_;

    Distance_restraint (Atom &       atom1, 
                        Atom &       atom2,
                        Text const & type,
                        double       R_eqv,
                        double       K_r);

public:
    Interaction * clone () const 
    {
        return new Distance_restraint (atom1_, atom2_, "", R_eqv_, K_r_);
    }
    explicit                Distance_restraint (Prototype &);

    Distance_restraint *    clone (Atom &       atom1,
                                   Atom &       atom2,
                                   Text const & type,
                                   double       R_eqv,
                                   double       K_r) const;

    double                  potential ();
    void                    add_force ();

    Text                    title () const {return "Distance restraint";}
};

}//MM

#endif //DISTANCE_RESTRAINT_H
