#ifndef HARMONIC_POTENTIAL_H
#define HARMONIC_POTENTIAL_H

#ifndef INTERACTION_FRAME_H
#include "Interaction_frame.h"
#endif

#ifndef LENGTH_H
#include "Length.h"
#endif

//fix remove
#ifndef FLAW_H
#include "Flaw.h"
#endif

namespace MM
{
class Atom;

class Harmonic_potential : public Interaction_frame
{
    Atom &      atom1_;
    Atom &      atom2_;
    Length      length_;                // Angstrom
    double      force_constant_      ;  // kcal / mol angstrom 2  //fix to 1/2
    double      equilibrium_distance_;  // angstrom

public:
    Interaction * clone () const{return new Harmonic_potential(atom1_, atom2_);}
    Harmonic_potential (Atom & atom1, Atom & atom2);

    Harmonic_potential (Atom & atom1,                 Atom & atom2,
                        double equilibrium_distance,  double force_constant);

    virtual double      potential ();
    virtual void        add_force ();

    Text                title () const {return "Harmonic";}

    double      force_constant      () const    {return force_constant_;}
    double      equilibrium_distance() const    {return equilibrium_distance_;}

    void        set_force_constant       (double new_value) {force_constant_ = new_value;}
    void        set_equilibrium_distance (double new_value) {equilibrium_distance_ = new_value;}
};

}//MM

#endif //HARMONIC_POTENTIAL_H
