#ifndef INTERACTION_FRAME_H
#define INTERACTION_FRAME_H

#ifndef INTERACTION_H
#include "Interaction.h"
#endif

namespace MM
{

class Interaction_frame : public Interaction
{
protected:
    double          last_potential_;

    double          w_, wx_, wy_, wz_;

public:
    Interaction_frame () : last_potential_(0), w_(0), wx_(0), wy_(0), wz_(0) { }

    void            report (Text *result, Text const & hint);

    bool            locked () const {return true;}
    void            set_lock (bool) {;}

    void            zero_virial ()                                              {w_=0.;  wx_=0.;  wy_=0.;  wz_=0.;}
    double          virial () const                                             {return w_;}
    double          virial (double *x, double *y, double *z) const              {*x=wx_; *y=wy_; *z=wz_; return w_;}
    void            set_virial (double w, double x=0, double y=0, double z=0)   {w_=w;  wx_=x;  wy_=y;  wz_=z;}
    void            add_virial (double w, double x=0, double y=0, double z=0)   {w_+=w; wx_+=x; wy_+=y; wz_+=z;}

    virtual void    zero_forces () {;}
};

}//MM

#endif //INTERACTION_FRAME_H
