#include "Test.h"

//#include "Log.h"
//#include "User.h"

#include "Timer.h"
#include "Atom.h"
#include "Model.h"
#include "Model_kit.h"
#include "Path.h"
#include "Create.h"
#include "Force_field.h"
#include "Conventional_interactions.h"
#include "Commonplace_interactions.h"
#include "File_text_output.h"

namespace MM
{

class Nonbonded_interactions_test : public Test
{
    Conventional_interactions * link;

    Own<File_text_output>       out_;
    //Force_field *               force_field_;

public:
    Nonbonded_interactions_test (const Text & suite_name) 
        : Test (suite_name) 
    {
    }
    
    void run()
    {
        out_.adopt (new File_text_output (Path::report() +"Nonbonded_interactions_test.txt"));

        //force_field_ = new Force_field ("AMBER94");
        
        test_I512         ();         count_tests();

        //delete force_field_;
    }

    void test_I512 ()
    {
        Own <Model>     model (prototype <Model> (). clone ());
        model(). load (Path::tests() + "I512.hin");

        Text text;
        // Conventional_interactions
        {
            //Model_energy energy (model(), model(), *force_field_);
            //double E = energy.energy ();
            model().kit().set_force_field ("AMBER94");
            Conventional_interactions interactions (model()/*, *force_field_*/);
            Timer timer;
            double E = interactions.potential ();
            text += Text() + "Conventional E = " + E + " " +
                timer.elapsed() + " sec   \n";

            DOUBLES_EQUAL (E, 218.613681734554, 0.000000000001);
            // 0.0066 sec 0.0033
        }

        // Commonplace_interactions
        {
            Commonplace_interactions interactions (model()/*, *force_field_*/);
            Timer timer;
            double E = interactions.potential ();
            text += Text() + "Commonplace  E = " + E + " " +
                timer.elapsed() + " sec   ";

            DOUBLES_EQUAL (E, 218.613681734554, 0.000000000001);
        }
        out_().line (text);
    }
};

Nonbonded_interactions_test test_nonbonded_interactions ("correctness");

}//MM
