#ifndef YAKUB_RONCHI_INTERACTIONS_H
#define YAKUB_RONCHI_INTERACTIONS_H

#ifndef CONVENTIONAL_INTERACTIONS_H
#include "Conventional_interactions.h"
#endif

namespace MM
{
//  Eugene Yakub  and Claudio Ronchi 
// An efficient method for computation of long-ranged Coulomb forces
// in computer simulation of ionic fluids
// J. Chem. Phys. 119, 11556 (2003); doi:10.1063/1.1624364

class Yakub_Ronchi_interactions : public Conventional_interactions
{
public:
    Interaction * clone () const
    {
        return new Yakub_Ronchi_interactions (model_);
            //(atom_group_, bond_group_, force_field_);
    }

    //Common_interactions *   clone (Atom_group &  atom_group,
    //                               Bond_group &  bond_group,
    //                               Force_field & ff) const
    //{return new Yakub_Ronchi_interactions (atom_group, bond_group, ff);}

    Common_interactions *   clone (Model &       model/*,
                                   Force_field & ff*/) const
    {return new Yakub_Ronchi_interactions (model/*, ff*/);}

    //Yakub_Ronchi_interactions (Atom_group & atom_group, Force_field & ff);
    //Yakub_Ronchi_interactions (Atom_group & atom_group,
    //                           Bond_group & bond_group, Force_field & ff);
    Yakub_Ronchi_interactions (Model & model/*, Force_field & ff*/);

protected:
    virtual void        nonbonded_potential (Atom_cache & atom);
    virtual void        add_nonbonded_force (Atom_cache & atom);
};

}//MM

#endif //YAKUB_RONCHI_INTERACTIONS_H
