#include "Angle_unit.h"

#include "Text.h"
#include "Flaw.h"

namespace MM
{
Unit * Angle_unit::
clone () const
{
    Angle_unit *result   = new Angle_unit;
    result->current_type_ = current_type_;
    result->value_        = value_;
    return result;
}

double Angle_unit::
value_of_type (Text const & current_type) const
{
    if      (current_type == "rad")
        return rad ();

    else if (current_type == "deg")
        return deg ();

    else
        FLAW (Text() + "Unknown Angle_unit '" + current_type + "'.");
}

void Angle_unit::
set_value_of_type (double new_value, Text const & current_type)
{
    if      (current_type == "rad")
        set_rad (new_value);

    else if (current_type == "deg")
        set_deg (new_value);

    else
        FLAW (Text() + "Unknown Angle_unit '" + current_type + "'.");
}

Text const & Angle_unit::
type (int n)  const
{
    static const Text rad = "rad";
    static const Text deg = "deg";

    switch (n)
    {
    case 0: return rad;
    case 1: return deg;

    default: FLAW ("Out of range.");
    }
}

}//MM
