#ifndef ANGLE_UNIT_H
#define ANGLE_UNIT_H

#ifndef UNIT_H
#include "Unit.h"
#endif

namespace MM
{

class Angle_unit : public Unit
{
    double  value_;     // Radians

public:
    explicit        Angle_unit () : value_(0.) {set_current_type("rad");}
    Unit *          clone () const;

    double          rad     () const        {return   value_;}
    Angle_unit &    set_rad (double value)  {value_ = value; return *this;}

    double          deg     () const
                    {return   180. / 3.14159265358979323846 * value_;}

    Angle_unit &    set_deg (double value)
                    {value_= 3.14159265358979323846 / 180.*value; return *this;}

    // Unit interface
    double      value_of_type (Text const & current_type) const;
    void        set_value_of_type (double new_value, Text const & current_type);

    int         type_count () const         {return 2;}
    Text const& type (int n)  const;
};

}//MM

#endif //ANGLE_UNIT_H
