#ifndef ATOMIC_SYSTEM_OF_UNITS_H
#define ATOMIC_SYSTEM_OF_UNITS_H

#ifndef SYSTEM_OF_UNITS_H
#include "System_of_Units.h"
#endif

namespace MM
{

class Atomic_System_of_Units : public System_of_Units
{
public:
    double      length  (Length_unit const & v) const                           {return v.bohr();}
    double      energy  (Energy_unit const & v) const                           {return v.Hartree();}
    double      mass    () const                                                {return v.me();}
    double      charge  (Charge_unit const & v) const                           {return v.electron();}
    virtual double      time    (Duration_unit const & v) const {return v.atomic();}
    //virtual double      force   () const = 0;
    //virtual double      electric_conversion_factor() const = 0;
};

}//MM

#endif //ATOMIC_SYSTEM_OF_UNITS_H
