#include "Bond_length.h"

#include "Atom.h"

namespace MM
{

Bond_length::
Bond_length (Atom const & atom1, Atom const & atom2)
:
    //Length( (const Point_3D &)atom1, (const Point_3D &)atom2 )   //fix (const Point_3D &)
    Length (atom1.position(), atom2.position()),
    atom1_(atom1),
    atom2_(atom2)
{
       REQUIRE( "Atoms 1 and 2 are bound.", true ); //fix
}

Bond_length::
Bond_length (Bond const & bond)
:
    Length (bond.atom(0).position(), bond.atom(1).position()),
    atom1_(bond.atom(0)),
    atom2_(bond.atom(1))
{
}

}//MM
