#ifndef BOND_LENGTH_H
#define BOND_LENGTH_H

#ifndef LENGTH_H
#include "Length.h"
#endif

#ifndef DBC_H
#include "DbC.h"
#endif

#ifndef ATOM_H
#include "Atom.h"
#endif

#ifndef BOND_H
#include "Bond.h"
#endif

namespace MM
{

class Bond_length : public Length, protected DbC
{
    const Atom & atom1_;
    const Atom & atom2_;

public:
    Bond_length (Atom const & atom1, Atom const & atom2);
    Bond_length (Bond const & bond);

    const Atom &    first_atom  () const    {return atom1_;}
    const Atom &    second_atom () const    {return atom2_;}
};

}//MM

#endif //BOND_LENGTH_H
