#include "Charge_unit.h"

#include "Flaw.h"

namespace MM
{

Charge_unit::Charge_unit ()
:
    value_(0.)
{
    set_current_type("electron");
}

Unit * Charge_unit::
clone () const
{
    Charge_unit *result   = new Charge_unit;
    result->current_type_ = current_type_;
    result->value_        = value_;
    return result;
}

double Charge_unit::
value_of_type (Text const & current_type) const
{
    if      (current_type == "electron")
        return electron ();

    else if (current_type == "C")
        return C ();

    else if (current_type == "Fr")
        return Fr ();

    else
        FLAW (Text() + "Unknown Charge_unit '" + current_type + "'.");
}

void Charge_unit::
set_value_of_type (double new_value, Text const & current_type)
{
    if      (current_type == "electron")
        set_electron (new_value);

    else if (current_type == "C")
        set_C (new_value);

    else if (current_type == "Fr")
        set_Fr (new_value);

    else
        FLAW (Text() + "Unknown Charge_unit '" + current_type + "'.");
}

Text const& Charge_unit::
type (int n) const
{
    static const Text electron = "electron";
    static const Text Coulomb  = "C";
    static const Text Franklin  = "Fr";

    switch (n)
    {
    case 0: return electron;
    case 1: return Coulomb;
    case 2: return Franklin;
    default: FLAW ("Out of range.");
    }
}

}//MM
