#ifndef CHARGE_UNIT_H
#define CHARGE_UNIT_H

#ifndef UNIT_H
#include "Unit.h"
#endif

namespace MM
{

class Charge_unit : public Unit
{
    double  value_;     // electron

public:
    explicit            Charge_unit ();
    Unit *              clone () const;

    double              electron     () const       {return   value_;}
    Charge_unit &       set_electron (double value) {value_ = value; return *this;}

    // Coulomb    SI
    double              C     () const       {return  1.60217648740e-19*value_;}
    Charge_unit &       set_C (double value)
                                    {value_ = value/1.60217648740e-19; return *this;}
    // Franklin
    double              Fr      () const       {return  3.33564e-10*1.60217648740e-19*value_;}
    Charge_unit &       set_Fr (double value)
                                    {value_ = value/(3.33564e-10*1.60217648740e-19); return *this;}

    // Unit interface
    double      value_of_type (Text const & current_type) const;
    void        set_value_of_type (double new_value, Text const & current_type);

    int         type_count () const         {return 3;}
    Text const& type (int n)  const;
};

}//MM

#endif //CHARGE_UNIT_H
