#include "Density.h"

#include "Mass_unit.h"
#include "Model_kit.h"

namespace MM
{

double Density::
value() const
{
    if (model_.kit().boundary_conditions ().type_name() != "Box")
        return 0.;
    Box const& box = model_.kit().boundary_conditions().box();
    double V = box.volume();         //fix A**3 to units

    int count = model_.atom_count();
    double mass = 0;

    for (int i=0;  i<count;  ++i)
        mass += model_.atom(i).ff_mass();

    Mass_unit   unit;
    unit.set_amu (mass);
    double result = 1e27 * unit.kg() / V;
    return result;
}

}//MM
