#ifndef DIHEDRAL_ANGLE_H
#define DIHEDRAL_ANGLE_H

#ifndef FUNCTION_H
#include "Function.h"
#endif

namespace MM
{
class Point_3D;

class Dihedral_angle :  public Function
{
protected:
    const Point_3D & vector1_;
    const Point_3D & vector2_;
    const Point_3D & vector3_;
    const Point_3D & vector4_;

public:
    Dihedral_angle (Point_3D const & vector1,
                    Point_3D const & vector2,
                    Point_3D const & vector3,
                    Point_3D const & vector4);

    virtual double value() const;
};

}//MM

#endif //DIHEDRAL_ANGLE_H
