#include "Dipole_moment_unit.h"

#include "Flaw.h"

namespace MM
{

Dipole_moment_unit::Dipole_moment_unit ()
:
    value_(0.)
{
    set_current_type("D");
}

Unit *  Dipole_moment_unit::
clone () const
{
    Dipole_moment_unit *result = new Dipole_moment_unit;
    result->current_type_ = current_type_;
    result->value_        = value_;
    return result;
}

double Dipole_moment_unit::
value_of_type (Text const & current_type) const
{
    if      (current_type == "D")
        return D ();

    else if (current_type == "Cm")
        return Cm ();

    else
        FLAW (Text() + "Unknown Dipole_moment_unit '" + current_type + "'.");
}

void Dipole_moment_unit::
set_value_of_type (double new_value, Text const & current_type)
{
    if      (current_type == "D")
        set_D (new_value);

    else if (current_type == "Cm")
        set_Cm (new_value);

    else
        FLAW (Text() + "Unknown Dipole_moment_unit '" + current_type + "'.");
}

Text const& Dipole_moment_unit::
type (int n) const
{
    static const Text D  = "D";
    static const Text Cm = "Cm";

    switch (n)
    {
    case 0: return D;
    case 1: return Cm;
    default: FLAW ("Out of range.");
    }
}

}//MM
