#ifndef DIPOLE_MOMENT_UNIT_H
#define DIPOLE_MOMENT_UNIT_H

#ifndef UNIT_H
#include "Unit.h"
#endif

namespace MM
{

class Dipole_moment_unit : public Unit
{
    double  value_;     // debye

public:
    explicit            Dipole_moment_unit ();
    Unit *              clone () const;

    double              D     () const       {return   value_;}
    Dipole_moment_unit & set_D (double value) {value_ = value; return *this;}

    // SI
    double              Cm     () const       {return  3.33564e-30*value_;}
    Dipole_moment_unit & set_Cm (double value)
                                    {value_ = value/3.33564e-30; return *this;}

    // Unit interface
    double      value_of_type (Text const & current_type) const;
    void        set_value_of_type (double new_value, Text const & current_type);

    int         type_count () const         {return 2;}
    Text const& type (int n)  const;
};

};

#endif //DIPOLE_MOMENT_UNIT_H
