#include "Duration_unit.h"

#include "Flaw.h"

namespace MM
{
//const double Duration_unit::default_step_length = 0.0047;
//const double Duration_unit::default_step_length = 0.0045;
//const double Duration_unit::default_step_length = 0.004;    //PEFRL
const double Duration_unit::default_step_length = 0.003;    //OPVL
//const double Duration_unit::default_step_length = 0.0025;

//const double Duration_unit::default_step_length = 0.002;    // Position_verlet
//const double Duration_unit::default_step_length = 0.004;    // Position_verlet H=30

//const double Duration_unit::default_step_length = 0.0016;
//const double Duration_unit::default_step_length = 0.001;

//const double Duration_unit::default_step_length = 0.0005;

//const double Duration_unit::default_step_length = 0.0001;
//const double Duration_unit::default_step_length = 0.00001;
//const double Duration_unit::default_step_length = 0.000001;


Duration_unit::
Duration_unit ()
:
    value_(2.), step_length_(default_step_length)
{}

Duration_unit::
Duration_unit (double value)
:
    value_(value), step_length_(default_step_length)
{
    set_current_type("ps");
}

Unit * Duration_unit::
clone () const
{
    Duration_unit *result = new Duration_unit;
    result->current_type_ = current_type_;
    result->value_        = value_;
    result->step_length_  = step_length_;
    return result;
}

// Unit interface
double Duration_unit::
value_of_type (Text const & current_type) const
{
    if      (current_type == "ps")
        return ps ();

    else if (current_type == "steps")
        return steps ();

    else if (current_type == "fs")
        return fs ();

    else if (current_type == "ns")
        return ns ();

    else if (current_type == "sec")
        return sec ();
    else
        FLAW (Text() + "Unknown Duration_unit '" + current_type + "'.");
}

void Duration_unit::
set_value_of_type (double new_value, Text const & current_type)
{
    if      (current_type == "ps")
        set_ps (new_value);

    else if (current_type == "steps")
        set_steps (new_value);

    else if (current_type == "fs")
        set_fs (new_value);

    else if (current_type == "ns")
        set_ns (new_value);

    else if (current_type == "sec")
        set_sec (new_value);

    else
        FLAW (Text() + "Unknown Duration_unit '" + current_type + "'.");
}
Text const& Duration_unit::
type (int n)  const
{
    static const Text ps    = "ps";
    static const Text steps = "steps";
    static const Text fs    = "fs";
    static const Text ns    = "ns";
    static const Text sec   = "sec";

    switch (n)
    {
    case 0: return ps;
    case 1: return steps;
    case 2: return fs;
    case 3: return ns;
    case 4: return sec;

    default: FLAW ("Out of range.");
    }
}

}//MM

