#ifndef DURATION_UNIT_H
#define DURATION_UNIT_H

#ifndef UNIT_H
#include "Unit.h"
#endif

namespace MM
{

class Duration_unit : public Unit
{
    static const double default_step_length;

    double      value_;         // ps
    double      step_length_;

public:
                Duration_unit ();
    explicit    Duration_unit (double );
    Unit *      clone () const;

    double          ps        () const        {return   value_;}
    Duration_unit & set_ps    (double value)  {value_ = value; return *this;}

    double          steps           () const        
    {
        return  step_length_ <= 0. ? 0. : value_/ step_length_;
    }
    Duration_unit & set_steps       (double steps)
                        {value_ = steps * step_length_; return *this;}
    double          step_length_ps     () const        {return step_length_;}  // ps   //fix
    Duration_unit & set_step_length_ps (double value)
                        {step_length_ = value; return *this;} // ps

    double          fs      () const        {return       1000. *value_;}
    Duration_unit & set_fs  (double value)
                        {value_ = 1./ 1000. *value; return *this;}

    double          ns      () const        {return   1./ 1000. *value_;}
    Duration_unit & set_ns  (double value)
                        {value_ =     1000. *value; return *this;}

    double          sec     () const        {return   1./ 1.e12 *value_;}
    Duration_unit & set_sec (double value)
                        {value_ =     1.e12 *value; return *this;}

    double          AKMA    () const        {return   1./ 0.04888 *value_;}
    Duration_unit & set_AKMA(double value)
                        {value_ =     0.04888 *value; return *this;}

    double          atomic    () const      {return  1./ 2.418884326505e-5 *value_;}
    Duration_unit & set_atomic(double value)
                        {value_ =    2.418884326505e-5 *value; return *this;}

    // Unit interface
    double      value_of_type (Text const & current_type) const;
    void        set_value_of_type (double new_value, Text const & current_type);

    int         type_count () const     {return 5;}
    Text const& type (int n)  const;
};

}//MM

#endif //DURATION_UNIT_H
