#include "Energy_unit.h"
#include "Flaw.h"

namespace MM
{

Energy_unit::
Energy_unit ()
:
    value_(0.)
{
    set_current_type("kcal/mol");
}

Unit * Energy_unit::
clone () const
{
    Energy_unit *result   = new Energy_unit;
    result->current_type_ = current_type_;
    result->value_        = value_;
    return result;
}

double Energy_unit::
value_of_type (Text const & current_type) const
{
    if      (current_type == "kcal/mol")
        return kcalImol ();

    else if (current_type == "kJ/mol")
        return kJImol ();

    else if (current_type == "J/mol")
        return JImol ();

    else if (current_type == "Hartrees")
        return Hartrees ();

    else if (current_type == "eV")
        return eV ();

    else if (current_type == "cm-1")
        return lIcm ();

    else if (current_type == "K")
        return K ();

    else
        FLAW (Text() + "Unknown Energy_unit '" + current_type + "'.");
}

void Energy_unit::
set_value_of_type (double new_value, Text const & current_type)
{
    if      (current_type == "kcal/mol")
        set_kcalImol (new_value);

    else if (current_type == "kJ/mol")
        set_kJImol (new_value);

    else if (current_type == "J/mol")
        set_JImol (new_value);

    else if (current_type == "Hartrees")
        set_Hartrees (new_value);

    else if (current_type == "eV")
        set_eV (new_value);

    else if (current_type == "cm-1")
        set_lIcm (new_value);

    else if (current_type == "K")
        set_K (new_value);

    else
        FLAW (Text() + "Unknown Pressure_unit '" + current_type + "'.");
}

Text const& Energy_unit::
type (int n) const
{
    static const Text kcalImol = "kcal/mol";
    static const Text kJImol   = "kJ/mol";
    static const Text JImol    = "J/mol";
    static const Text Hartrees = "Hartrees";
    static const Text eV       = "eV";
    static const Text lIcm     = "cm-1";
    static const Text K        = "K";

    switch (n)
    {
    case 0: return kcalImol;
    case 1: return kJImol;
    case 2: return JImol;
    case 3: return Hartrees;
    case 4: return eV;
    case 5: return lIcm;
    case 6: return K;

    default: FLAW ("Out of range.");
    }
}

}//MM
