#ifndef ENERGY_UNIT_H
#define ENERGY_UNIT_H

#ifndef UNIT_H
#include "Unit.h"
#endif

namespace MM
{

class Energy_unit : public Unit
{
    double  value_;     // kcal/mol

public:
    explicit            Energy_unit ();
    Unit *              clone () const;

    double              kcalImol     () const                                   {return   value_;}
    Energy_unit &       set_kcalImol (double value)                             {value_ = value; return *this;}

    double              kJImol     () const                                     {return   4.184*value_;}
    Energy_unit &       set_kJImol (double value)                               {value_ = value/4.184; return *this;}

    double              JImol     () const                                      {return   4184*value_;}
    Energy_unit &       set_JImol (double value)                                {value_ = value/4184; return *this;}

    double              Hartrees     () const                                   {return   0.001593601*value_;}
    Energy_unit &       set_Hartrees (double value)                             {value_ = value/0.001593601; return *this;}

    double              eV     () const                                         {return   0.043364115*value_;}
    Energy_unit &       set_eV (double value)                                   {value_ = value/0.043364115; return *this;}

    double              lIcm     () const                                       {return   349.755011*value_;}
    Energy_unit &       set_lIcm (double value)                                 {value_ = value/349.755011; return *this;}

    double              K     () const                                          {return   503.222717*value_;}
    Energy_unit &       set_K (double value)                                    {value_ = value/503.222717; return *this;}

    // Unit interface
    double      value_of_type (Text const & current_type) const;
    void        set_value_of_type (double new_value, Text const & current_type);

    int         type_count () const         {return 7;}
    Text const& type (int n)  const;
};

}//MM


#endif //ENERGY_UNIT_H
