#include "Force_unit.h"

#include "Flaw.h"

namespace MM
{

Force_unit::Force_unit ()
:
    value_(0.)
{
    set_current_type("kcal/mol*A");
}

Unit * Force_unit::
clone () const
{
    Force_unit *result    = new Force_unit;
    result->current_type_ = current_type_;
    result->value_        = value_;
    return result;
}

double Force_unit::
value_of_type (Text const & current_type) const
{
    if      (current_type == "kcal/mol*A")
        return kcalImolA ();

    else if (current_type == "N")
        return N ();

    else
        FLAW (Text() + "Unknown Force_unit '" + current_type + "'.");
}

void Force_unit::
set_value_of_type (double new_value, Text const & current_type)
{
    if      (current_type == "kcal/mol*A")
        set_kcalImolA (new_value);

    else if (current_type == "N")
        set_N (new_value);

    else
        FLAW (Text() + "Unknown Force_unit '" + current_type + "'.");
}

Text const& Force_unit::
type (int n) const
{
    static const Text kcalImolA = "kcal/mol*A";
    static const Text N         = "N";

    switch (n)
    {
    case 0: return kcalImolA;
    case 1: return N;
    default: FLAW ("Out of range.");
    }
}

}//MM
