#ifndef FORCE_UNIT_H
#define FORCE_UNIT_H

#ifndef UNIT_H
#include "Unit.h"
#endif

namespace MM
{

class Force_unit : public Unit
{
    double  value_;     // kcal/mol*A

public:
    explicit            Force_unit ();
    Unit *              clone () const;

    double              kcalImolA     () const       {return   value_;}
    Force_unit &        set_kcalImolA (double value) {value_ = value; return *this;}

    double              N      () const       {return  6.951e-11*value_;}
    Force_unit &        set_N (double value)
                                    {value_ = value/6.951e-11; return *this;}

    // Unit interface
    double      value_of_type (Text const & current_type) const;
    void        set_value_of_type (double new_value, Text const & current_type);

    int         type_count () const         {return 2;}
    Text const& type (int n)  const;
};

}//MM

#endif //FORCE_UNIT_H
