#ifndef INFORMATION_H
#define INFORMATION_H

#ifndef TEXT_H
#include "Text.h"
#endif

#ifndef EVENT_H
#include "Event.h"
#endif

namespace MM
{
class Text;

class Information
{
    Text                    log_;
    Event                   next_log_;

public:
    static Information &    singleton ();
    static void             warning (Text const& message);
    static void             error   (Text const& message);

    void                    session  (Text &result);
    void                    project  (Text &result);
    void                    model    (Text &result);
    void                    selected (Text &result);
    void                    problems (Text &result);
    void                    log      (Text &result);

    void                    add_log  (Text const& log);
    void                    on_log   (Command *adoptee, bool on);
};

}//MM

#endif //INFORMATION_H
