#include "Length.h"

#include "Point_3D.h"
#include "math.h"

namespace MM
{

Length::
Length (Point_3D const & point1, Point_3D const & point2)
:
    v_1_( point1 ),
    v_2_( point2 )
{
}

double Length::
value () const
{
    double x =  v_1_.x() -  v_2_.x();
    double y =  v_1_.y() -  v_2_.y();
    double z =  v_1_.z() -  v_2_.z();

    return sqrt( x*x + y*y + z*z );
}

double Length::
value_2() const
{
    double x =  v_1_.x() -  v_2_.x();
    double y =  v_1_.y() -  v_2_.y();
    double z =  v_1_.z() -  v_2_.z();

    return x*x + y*y + z*z;
}

}//MM
